/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.modelgen;

import ibm.nways.jdm.RemoteStatusImpl;
import ibm.nways.jdm.StatusImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.ComponentStatusImpl;
import ibm.nways.jdm.modelgen.LocalCompoundStatus;
import ibm.nways.jdm.modelgen.LocalModel;
import ibm.nways.jdm.modelgen.LocalStatus;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Vector;

public class LocalComponentStatus
extends LocalCompoundStatus
implements LocalStatus {
    protected Vector components;
    protected String schemeId;
    protected int useCount;

    public LocalComponentStatus(LocalModel localModel, String string) {
        super(localModel, string);
        this.schemeId = string;
        String string2 = String.valueOf(this.schemeId) + ".components";
        Serializable serializable = null;
        serializable = this.locmod.getPersistentInfo(string2);
        this.components = serializable != null ? (Vector)serializable : this.locmod.getInstr().getDefaultMonitoredComponents();
        if (this.components != null && this.components.size() == 0) {
            this.setStatusType(StatusType.UNMANAGED, null, true);
        }
    }

    public RemoteStatusImpl getRemoteStatusObj() throws RemoteException {
        RemoteStatusImpl remoteStatusImpl = null;
        LocalComponentStatus localComponentStatus = this;
        synchronized (localComponentStatus) {
            if (this.rs == null) {
                this.rs = new ComponentStatusImpl(this);
            }
            remoteStatusImpl = this.rs;
        }
        return remoteStatusImpl;
    }

    public void monitor(String string) throws RemoteException {
        if (!this.components.contains(string)) {
            this.components.addElement(string);
            String string2 = String.valueOf(this.schemeId) + ".components";
            this.locmod.savePersistentInfo(string2, (Serializable)this.components);
            LocalModel localModel = this.locmod.getComponent(string);
            if (localModel != null) {
                LocalStatus localStatus = localModel.getLocalStatus(this.schemeId);
                this.addDependent((StatusImpl)((Object)localStatus));
                localStatus.startStatus();
            }
        }
    }

    public void doNotMonitor(String string) throws RemoteException {
        if (this.components.contains(string)) {
            Object object;
            this.components.removeElement(string);
            String string2 = String.valueOf(this.schemeId) + ".components";
            this.locmod.savePersistentInfo(string2, (Serializable)this.components);
            LocalModel localModel = this.locmod.getComponent(string);
            if (localModel != null) {
                object = localModel.getLocalStatus(this.schemeId);
                this.removeDependent((StatusImpl)object);
                object.stopStatus();
            }
            if (this.components.size() == 0) {
                this.setStatusType(StatusType.UNMANAGED, null, true);
                try {
                    object = null;
                    LocalComponentStatus localComponentStatus = this;
                    synchronized (localComponentStatus) {
                        object = this.rs;
                    }
                    if (object != null) {
                        ((RemoteStatusImpl)object).setStatusType(StatusType.UNMANAGED, null, true);
                        return;
                    }
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                    return;
                }
            }
        }
    }

    public boolean isMonitored(String string) throws RemoteException {
        return this.components.contains(string);
    }

    public Vector getComponents() {
        return this.components;
    }

    public void startStatus() {
        boolean bl = false;
        LocalComponentStatus localComponentStatus = this;
        synchronized (localComponentStatus) {
            ++this.useCount;
            if (this.useCount == 1) {
                bl = true;
            }
        }
        if (bl) {
            int n = 0;
            while (n < this.components.size()) {
                LocalComponentStatus localComponentStatus2;
                String string = (String)this.components.elementAt(n);
                try {
                    localComponentStatus2 = this.locmod.getComponent(string);
                    if (localComponentStatus2 != null) {
                        StatusImpl statusImpl = (StatusImpl)((Object)localComponentStatus2.getLocalStatus(this.schemeId));
                        if (statusImpl != null) {
                            this.addDependent(statusImpl);
                            ((LocalStatus)((Object)statusImpl)).startStatus();
                        } else {
                            System.out.println("\n\n* * * A null component status was found for " + localComponentStatus2.getInstr().getClass().getName() + " in class " + this.locmod.getInstr().getClass().getName());
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    localComponentStatus2 = this;
                    synchronized (localComponentStatus2) {
                        if (this.locmod != null) {
                            this.locmod.dispose();
                        }
                        this.locmod = null;
                    }
                }
                ++n;
            }
        }
    }

    public void stopStatus() {
        boolean bl = false;
        Serializable serializable = this;
        synchronized (serializable) {
            --this.useCount;
            if (this.useCount <= 0) {
                bl = true;
                this.useCount = 0;
            }
        }
        if (bl) {
            serializable = this.getDependents();
            while (((Vector)serializable).size() > 0) {
                StatusImpl statusImpl = (StatusImpl)((Vector)serializable).elementAt(0);
                this.removeDependent(statusImpl);
                ((LocalStatus)((Object)statusImpl)).stopStatus();
            }
        }
    }

    public void reallyStopStatus() {
        Serializable serializable = this;
        synchronized (serializable) {
            this.useCount = 0;
        }
        this.setManager(null);
        serializable = this.getDependents();
        while (((Vector)serializable).size() > 0) {
            StatusImpl statusImpl = (StatusImpl)((Vector)serializable).elementAt(0);
            this.removeDependent(statusImpl);
            ((LocalStatus)((Object)statusImpl)).reallyStopStatus();
        }
        this.locmod = null;
    }

    public void refreshStatus() {
        Vector vector = this.getDependents();
        int n = 0;
        while (n < vector.size()) {
            ((LocalStatus)vector.elementAt(n)).refreshStatus();
            ++n;
        }
    }

    public void clearRemoteStatusObj() {
        LocalComponentStatus localComponentStatus = this;
        synchronized (localComponentStatus) {
            if (this.rs != null) {
                try {
                    this.rs.deleteWatchers();
                }
                catch (Exception exception) {}
            }
            this.rs = null;
            return;
        }
    }

    public void addComponent(String string) {
        boolean bl = false;
        LocalComponentStatus localComponentStatus = this;
        synchronized (localComponentStatus) {
            if (this.useCount > 0) {
                bl = true;
            }
        }
        if (bl && (localComponentStatus = this.locmod.getComponent(string)) != null) {
            StatusImpl statusImpl = (StatusImpl)((Object)localComponentStatus.getLocalStatus(this.schemeId));
            this.addDependent(statusImpl);
            ((LocalStatus)((Object)statusImpl)).startStatus();
        }
    }

    public void removeComponent(String string) {
        boolean bl = false;
        LocalComponentStatus localComponentStatus = this;
        synchronized (localComponentStatus) {
            if (this.useCount > 0) {
                bl = true;
            }
        }
        if (bl && (localComponentStatus = this.locmod.getComponent(string)) != null) {
            StatusImpl statusImpl = (StatusImpl)((Object)localComponentStatus.getLocalStatus(this.schemeId));
            this.removeDependent(statusImpl);
            ((LocalStatus)((Object)statusImpl)).stopStatus();
        }
    }
}

